<?php
include("includes/config.php");

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
include("includes/header.php");
include("includes/uselink.php");

// PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require("phpmailer/src/PHPMailer.php");
require("phpmailer/src/SMTP.php");
require("phpmailer/src/Exception.php");

$errors = [];
$success = "";

if ($_SERVER['REQUEST_METHOD'] == "POST") {

    $email_list = trim($_POST['emails']);

    if ($email_list == "") {
        $errors[] = "Please enter at least one email address.";
    }

    if (empty($errors)) {

        // Convert into array (supports comma OR new line)
        $emails = preg_split('/[\s,]+/', $email_list);

        // Petition link (STATIC)
        $form_link = "https://yourwebsite.com/petition-form.php";

        $sent_count = 0;

        foreach ($emails as $email) {

            $email = trim($email);
            if ($email == "") continue;

            $mail = new PHPMailer(true);

            try {
                // ================= SMTP SETTINGS =================
                $mail->isSMTP();
                $mail->Host       = 'smtp.gmail.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'mmglassemerest@gmail.com';     // your Gmail
                $mail->Password   = 'eculmkkisensgxbs';              // your Gmail app password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port       = 587;
                $mail->CharSet    = 'UTF-8';

                // OPTIONAL (turn ON for debugging)
                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;

                // ================= EMAIL DETAILS =================
                $mail->setFrom('service@mmglassnyc.com', 'School Petition System');
                $mail->addAddress($email);

                $mail->isHTML(true);
                $mail->Subject = "Please Sign Your School Petition";
                $mail->Body = "
                    <h3>Dear Parent,</h3>
                    <p>Please click the link below to sign the petition:</p>
                    <p><a href='$form_link' target='_blank'>$form_link</a></p>
                    <p>Thank you.</p>
                ";

                // SEND EMAIL
                $mail->send();
                $sent_count++;

            } catch (Exception $e) {
                // You can log $mail->ErrorInfo if needed
            }
        }

        $success = "$sent_count emails sent successfully!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Send Petition Forms</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container mt-5 mb-5">
<div class="card p-4 shadow-lg">

<h3 class="mb-4">Send Petition Form to Parents</h3>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <?php foreach ($errors as $e) echo "<div>$e</div>"; ?>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<form method="POST">

    <div class="mb-3">
        <label><b>Enter Parent Emails</b> (comma or new line separated):</label>
        <textarea name="emails" class="form-control" rows="6" placeholder="example1@gmail.com, example2@yahoo.com"></textarea>
    </div>

    <button class="btn btn-primary">Send Emails</button>

</form>

</div>
</div>

</body>
</html>
