<?php
include("includes/config.php");

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
include("includes/header.php");
include("includes/uselink.php");

// Fetch all petitions
$result = mysqli_query($conn, "SELECT * FROM petitions ORDER BY created_at DESC");

// Petition Count
$count_result = mysqli_query($conn, "SELECT COUNT(*) AS total FROM petitions");
$count_row = mysqli_fetch_assoc($count_result);
$total_petitions = $count_row['total'];
?>

<!DOCTYPE html>
<html>
<head>
<title>Admin Dashboard</title>

<!--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">-->

<!-- DATATABLE -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap5.min.js"></script>

<style>
body { background: #f5f5f5; }
.full-container { width: 100%; padding: 20px; }

</style>

</head>

<body>

<div class="full-container">

    <!-- TOP RIGHT COUNTER -->
   <div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="m-0">All Petitions</h2>
    <h4 class="m-0 text-primary">Total Petitions: <?= $total_petitions ?></h4>
</div>

    <div class="card p-3 shadow">

        <table id="petitionsTable" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Boys</th>
                    <th>Girls</th>
                    <th>Date</th>
                    <th>Action</th>
                    <th>Download PDF</th>
                </tr>
            </thead>

            <tbody>
            <?php while($r = mysqli_fetch_assoc($result)): ?>
            <tr id="row_<?= $r['id'] ?>">

                <td><?= $r['first_name'] . " " . $r['last_name'] ?></td>
                <td><?= $r['boys'] ?></td>
                <td><?= $r['girls'] ?></td>
                <td><?= date('Y-m-d', strtotime($r['created_at'])) ?></td>

                <td>
                    <button class="btn btn-danger btn-sm deleteBtn" data-id="<?= $r['id'] ?>">
                        Delete
                    </button>
                </td>

                <td>
                    <?php if (!empty($r['pdf_file_path'])): ?>
                      <a href="download.php?file=<?= $r['pdf_file_path'] ?>" class="btn btn-success btn-sm">
    Download
</a>

                    <?php else: ?>
                        <span class="text-danger">No PDF</span>
                    <?php endif; ?>
                </td>

            </tr>
            <?php endwhile; ?>
            </tbody>

        </table>
    </div>

</div>

<!-- DATATABLE INIT -->
<script>
$(document).ready(function() {
    $('#petitionsTable').DataTable({
        "pageLength": 10,
        "lengthMenu": [5, 10, 25, 50, 100],
        "order": [[0, "desc"]]
    });
});
</script>

<!-- DELETE AJAX -->
<script>
$(document).ready(function(){

    $(".deleteBtn").click(function(){

        if (!confirm("Are you sure you want to delete this petition?")) {
            return;
        }

        var id = $(this).data("id");

        $.ajax({
            url: "delete.php",
            method: "POST",
            data: { id: id },
            success: function(response){

                if(response.trim() == "success"){
                    $("#row_" + id).fadeOut(400, function(){
                        $(this).remove();
                    });
                } else {
                    alert("Delete failed!");
                }
            }
        });

    });

});
</script>

</body>
</html>
