<?php
include("includes/config.php");

if (!isset($_SESSION['user'])) {
    echo "Unauthorized!";
    exit;
}

// When form submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
    $last_name  = mysqli_real_escape_string($conn, $_POST['last_name']);
    $boys       = (int)$_POST['boys'];
    $girls      = (int)$_POST['girls'];
    $signature  = mysqli_real_escape_string($conn, $_POST['signature']);

    // ---- STEP 1: Insert petition first ----
    $sql = "INSERT INTO petitions (first_name, last_name, boys, girls, signature_text, created_at)
            VALUES ('$first_name', '$last_name', '$boys', '$girls', '$signature', NOW())";

    mysqli_query($conn, $sql);

    $new_id = mysqli_insert_id($conn); // NEW petition entry id

    // ---- STEP 2: Upload hard copy ----
    if ($_FILES['hardcopy']['error'] == 0) {

        $folder = "hardcopies/";
        if (!file_exists($folder)) mkdir($folder, 0777, true);

        $ext = strtolower(pathinfo($_FILES['hardcopy']['name'], PATHINFO_EXTENSION));
        $allowed = ['pdf', 'jpg', 'jpeg', 'png'];

        if (!in_array($ext, $allowed)) {
            die("Only PDF/JPG/PNG allowed!");
        }

        $filename = "hardcopy_" . $new_id . "." . $ext;
        $path = $folder . $filename;

        move_uploaded_file($_FILES['hardcopy']['tmp_name'], $path);

        mysqli_query($conn,
            "UPDATE petitions SET hardcopy_path='$path' WHERE id=$new_id"
        );
    }

    echo "<script>
        alert('Hard copy petition added successfully!');
        window.location='index.php';
    </script>";
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Upload Hard Copy Petition</title>
<link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css'>
</head>

<body class='p-4'>
<div class="container">
    <h3>Upload Hard Copy Petition</h3>

    <div class="card p-3 mt-3">

        <form method="POST" enctype="multipart/form-data">

            <div class="row">
                <div class="col-md-4">
                    <label>First Name</label>
                    <input name="first_name" class="form-control" required>
                </div>

                <div class="col-md-4">
                    <label>Last Name</label>
                    <input name="last_name" class="form-control" required>
                </div>

                <div class="col-md-2">
                    <label>Boys</label>
                    <input type="number" name="boys" class="form-control" required>
                </div>

                <div class="col-md-2">
                    <label>Girls</label>
                    <input type="number" name="girls" class="form-control" required>
                </div>
            </div>

            <div class="mt-3">
                <label>Signature Text</label>
                <input name="signature" class="form-control">
            </div>

            <div class="mt-3">
                <label>Upload Hard Copy (PDF/JPG/PNG)</label>
                <input type="file" name="hardcopy" class="form-control" required>
            </div>

            <button class="btn btn-primary mt-3">Save Petition</button>
        </form>

    </div>
</div>
</body>
</html>
